function  [ztrata u y b P]=alstr(regulator_parameters,system,apriori,seed)
horizont=regulator_parameters.horizont;
sigma=system.sigma;

y=zeros(1,horizont);
b=zeros(1,horizont-1);
P=zeros(1,horizont-1);
u=zeros(1,horizont-1);
ztrata=0;

y(1)=apriori(1);
b(1)=apriori(2);
P(1)=apriori(3);


    for i=1:horizont-1   
        eta=abs(y(i))/sigma;
        beta=abs(b(i))/sqrt(P(i));
        ny=(0.56+beta)/(2.2+0.08*beta+beta^2)*eta+1.9/(1.7+beta^4);
        
        znamenko=sign(y(i)*((-1)^(b(i)<0)));
        u(i)=-ny*sigma/sqrt(P(i))*znamenko;
        
        y(i+1)=y(i)+system.b*u(i)+sigma*seed(i);
        K=u(i)*P(i)/(P(i)*u(i)^2+sigma^2);
        b(i+1)=b(i)+K*(y(i+1)-y(i)-b(i)*u(i));
        P(i+1)=(1-K*u(i))*P(i);   
        
        ztrata=ztrata+y(i+1)^2;
        
    end
 end
